--
-- UseYourTyres settings
-- V1.0
-- @author 50keda
-- @date 26/04/2025
-- Copyright (C) 50keda, All Rights Reserved.

UseYourTyresSettings = {}
UseYourTyresSettings.tyreDistanceTexts = { 
    g_i18n:getText(InGameMenuSettingsFrame.L10N_SYMBOL.USAGE_LOW), 
    g_i18n:getText(InGameMenuSettingsFrame.L10N_SYMBOL.USAGE_DEFAULT), 
    g_i18n:getText(InGameMenuSettingsFrame.L10N_SYMBOL.USAGE_HIGH)
}
UseYourTyresSettings.tyreDistanceMultipliers = {
    10,
    1,
    0.1
}

function UseYourTyresSettings:onFrameOpen()
    if self.uytSettingsDone then
        return
    end

    UseYourTyresSettings.cachedFrame = self
    
    UseYourTyresSettings:addTitle(self)
    UseYourTyres.uytWearRateSetting = UseYourTyresSettings:addMultiTextOption(
        self, 
        "onTyreDistanceValueChanged", 
        UseYourTyresSettings.tyreDistanceTexts, 
        g_i18n:getText("ui_uytSettingsTyreDistanceTitle"), 
        g_i18n:getText("ui_uytSettingsTyreDistanceDescription")
    )

    self.gameSettingsLayout:invalidateLayout()
	self:updateAlternatingElements(self.gameSettingsLayout)
	self:updateGeneralSettings(self.gameSettingsLayout)

    self.uytSettingsDone = true
    UseYourTyresSettings:updateSettings()
end

function UseYourTyresSettings:addTitle(inGameMenuSettingsFrame)
    local textElement = TextElement.new()
    local textElementProfile = g_gui:getProfile("fs25_settingsSectionHeader")
    textElement.name = "sectionHeader"
    textElement:loadProfile(textElementProfile, true)
    textElement:setText(g_i18n:getText("ui_uytSettingsTitle"))
    inGameMenuSettingsFrame.gameSettingsLayout:addElement(textElement)
    textElement:onGuiSetupFinished()
    textElement.focusId = FocusManager:serveAutoFocusId()
end

function UseYourTyresSettings:addMultiTextOption(inGameMenuSettingsFrame, onClickCallback, texts, title, tooltip)
    local bitMap = BitmapElement.new()
    local bitMapProfile = g_gui:getProfile("fs25_multiTextOptionContainer")
    bitMap:loadProfile(bitMapProfile, true)
    bitMap.focusId = FocusManager:serveAutoFocusId()

    local multiTextOption = MultiTextOptionElement.new()
    local multiTextOptionProfile = g_gui:getProfile("fs25_settingsMultiTextOption")
    multiTextOption:loadProfile(multiTextOptionProfile, true)
    multiTextOption.target = UseYourTyresSettings
    UseYourTyresSettings.name = inGameMenuSettingsFrame.name
    multiTextOption:setCallback("onClickCallback", onClickCallback)
    multiTextOption:setTexts(texts)
    multiTextOption.focusId = FocusManager:serveAutoFocusId()


    local multiTextOptionTitle = TextElement.new()
    local multiTextOptionTitleProfile = g_gui:getProfile("fs25_settingsMultiTextOptionTitle")
    multiTextOptionTitle:loadProfile(multiTextOptionTitleProfile, true)
    multiTextOptionTitle:setText(title)
    multiTextOptionTitle.focusId = FocusManager:serveAutoFocusId()

    local multiTextOptionTooltip = TextElement.new()
    local multiTextOptionTooltipProfile = g_gui:getProfile("fs25_multiTextOptionTooltip")
    multiTextOptionTooltip.name = "ignore"
    multiTextOptionTooltip:loadProfile(multiTextOptionTooltipProfile, true)
    multiTextOptionTooltip:setText(tooltip)
    multiTextOptionTooltip.focusId = FocusManager:serveAutoFocusId()

    multiTextOption:addElement(multiTextOptionTooltip)
    bitMap:addElement(multiTextOption)
    bitMap:addElement(multiTextOptionTitle)

    FocusManager:loadElementFromCustomValues(bitMap, nil, nil, false, false)
    FocusManager:loadElementFromCustomValues(multiTextOption, nil, nil, false, false)
    FocusManager:loadElementFromCustomValues(multiTextOptionTitle, nil, nil, false, false)

    multiTextOption:onGuiSetupFinished()
    multiTextOptionTitle:onGuiSetupFinished()
    multiTextOptionTooltip:onGuiSetupFinished()

    inGameMenuSettingsFrame.gameSettingsLayout:addElement(bitMap)
    bitMap:onGuiSetupFinished()
    
    return multiTextOption
end

function UseYourTyresSettings:updateSettings()
    if UseYourTyres.uytWearRateSetting == nil then
        return
    end

    for index, value in pairs(UseYourTyresSettings.tyreDistanceTexts) do
        if value == UseYourTyresSettings.tyreDistanceTexts[index] and math.abs(UseYourTyres.tyreDistanceMultiplier - UseYourTyresSettings.tyreDistanceMultipliers[index]) < 0.0001 then
            UseYourTyres.uytWearRateSetting:setState(index)
            -- print("FOUND THE VALUE:" .. value .. " with index: " .. index .. " with diff: " .. math.abs(UseYourTyres.tyreDistanceMultiplier - UseYourTyresSettings.tyreDistanceMultipliers[index]))
            return
        end
    end
end

function UseYourTyresSettings:onTyreDistanceValueChanged(state)
    local tyreDistanceMultiplier = UseYourTyresSettings.tyreDistanceMultipliers[state]
    UseYourTyres.tyreDistanceMultiplier = tyreDistanceMultiplier 
    if g_server ~= nil then
        g_server:broadcastEvent(UytDistanceMultiplierEvent.new(tyreDistanceMultiplier)) -- server to other
    else
        g_client:getServerConnection():sendEvent(UytDistanceMultiplierEvent.new(tyreDistanceMultiplier)) -- client to other
    end
    UseYourTyresSettings:updateSettings()
    
    UseYourTyresSettings.cachedFrame:playSample(GuiSoundPlayer.SOUND_SAMPLES.CLICK)
end

InGameMenuSettingsFrame.onFrameOpen = Utils.appendedFunction(InGameMenuSettingsFrame.onFrameOpen, UseYourTyresSettings.onFrameOpen)

function UseYourTyresSettings.consoleCommandSetMultiplier(_, arg1)
    if arg1 == nil then
		return "No multiplier given! Usage: gsUytSetTravelDistanceMultiplier <multiplier (float bigger than zero)>"
	end

	local multiplierOverride = (tonumber(arg1) or UseYourTyres.tyreDistanceMultiplier)

    print("Console command overriding tyre distance multiplier: " .. multiplierOverride)

    UseYourTyres.tyreDistanceMultiplier = math.max(0.00001, multiplierOverride)
    if g_server ~= nil then
        g_server:broadcastEvent(UytDistanceMultiplierEvent.new(UseYourTyres.tyreDistanceMultiplier)) -- server to other
    else
        g_client:getServerConnection():sendEvent(UytDistanceMultiplierEvent.new(UseYourTyres.tyreDistanceMultiplier)) -- client to other
    end
end

addConsoleCommand("gsUytSetTravelDistanceMultiplier", "Override distance multiplier for tyre wear amount calculation. Use any value bigger than 0.00001, game settings use: LOW - 10, NORMAL - 1, HIGH - 0.1", "consoleCommandSetMultiplier", UseYourTyresSettings)
