stumpHighlighter = {
	active = false,
	stumps = {},
	SEARCH_RADIUS = 100,
	Y_OFFSET = 0.5,
	BASE_FONT_SIZE = 0.5,
	BASE_FONT_Y_OFFSET = 0.1,
	FONT_COLOR = {1, 1, 0, 1},
	ACTION_NAME = "TOGGLE_STUMP_HIGHLIGHTER",
	ACTIVATED_TEXT = "input_STUMP_HIGHLIGHTER_ACTIVE",
	DEACTIVATED_TEXT = "input_STUMP_HIGHLIGHTER_INACTIVE"
}

local me = stumpHighlighter

function stumpHighlighter:update(dt)
	me.updateActionEventText(me.toggleStumpHighlighterId)

	if not me.active then
		return
	end

	table.clear(me.stumps)

	local x, y, z = getWorldTranslation(getCamera())

	overlapSphere(x, y, z, me.SEARCH_RADIUS, "overlapCallback", me, CollisionFlag.TREE, false, true, true, false)
end

function stumpHighlighter:overlapCallback(objectId, ...)
	if not (getHasClassId(objectId, ClassIds.MESH_SPLIT_SHAPE) and getSplitType(objectId) ~= 0 and getRigidBodyType(objectId) == RigidBodyType.STATIC and getIsSplitShapeSplit(objectId)) then
		return
	end

	table.insert(me.stumps, objectId)
end

function stumpHighlighter:draw()
	if not me.active then
		return
	end

	setTextAlignment(RenderText.ALIGN_CENTER)
	setTextColor(unpack(me.FONT_COLOR))
	setTextBold(true)

	for _, stump in ipairs(me.stumps) do
		local wx, wy, wz = getWorldTranslation(stump)
		local sx, sy, sz = project(wx, wy + me.Y_OFFSET, wz)

		if sx > -1 and sx < 2 and sy > -1 and sy < 2 and sz <= 1 then
			local textSize = me.BASE_FONT_SIZE / calcDistanceFrom(stump, getCamera())
			local textYOffset = me.BASE_FONT_Y_OFFSET / calcDistanceFrom(stump, getCamera())
			renderText(sx, sy + textYOffset, textSize, "↓")
		end
	end

	setTextAlignment(RenderText.ALIGN_LEFT)
	setTextColor(1, 1, 1, 1)
	setTextBold(false)
end

function stumpHighlighter:inj_registerGlobalPlayerActionEvents(context)
	if not self.player.isOwner then
		return
	end

	local isNewContext = context ~= nil and context ~= g_inputBinding:getContextName()

	if isNewContext then
		g_inputBinding:beginActionEventsModification(context)
	end

	local _, actionEventId = g_inputBinding:registerActionEvent(me.ACTION_NAME, self, stumpHighlighter.actionEventTogglestumpHighlighter, false, true, false, true, nil, true)

	me.toggleStumpHighlighterId = actionEventId

	if isNewContext then
		g_inputBinding:endActionEventsModification()
	end
end

function stumpHighlighter:actionEventTogglestumpHighlighter()
	me.active = not me.active
end

function stumpHighlighter.updateActionEventText(actionEventId)
	if actionEventId == nil then
		return
	end

	local actionText = me.active and g_i18n:getText(me.ACTIVATED_TEXT) or g_i18n:getText(me.DEACTIVATED_TEXT)

	g_inputBinding:setActionEventText(actionEventId, actionText)
end

PlayerInputComponent.registerGlobalPlayerActionEvents = Utils.appendedFunction(PlayerInputComponent.registerGlobalPlayerActionEvents, stumpHighlighter.inj_registerGlobalPlayerActionEvents)
addModEventListener(stumpHighlighter)
