LowerReverseBeepVol = {}
--
-- v 0.9.1.3
-- SbSh / frvetz
-- 30.11.2022 - 0.9..
-- 22.12.2022 - 0.9.1.1 md:1.0.0.0
-- 11.04.2023 - 0.9.1.2 md:1.0.0.1
-- 11.11.2023 - 0.9.1.7 md:1.0.0.4
-- 14.11.2024 - 2.5.0.1 convert to fs25
-- 
-- ToDo
-- make it usable fpr fs25

local RDver = "2.5.0.1"
local RDauthor = "SbSh / frvetz"
local PTR = false

 print("load script LRBV FS25_LowerReverseBeepVol version " .. RDver .. " ".. RDauthor .." <--")
 
function LowerReverseBeepVol:loadedMission(mission, node, state)
    if g_currentMission:getIsServer() then
        if g_currentMission.missionInfo.savegameDirectory ~= nil and fileExists(g_currentMission.missionInfo.savegameDirectory .. "/LowerReverseBeepVol.xml") then
            local xmlFile = XMLFile.load("LowerReverseBeepVol", g_currentMission.missionInfo.savegameDirectory .. "/LowerReverseBeepVol.xml")
            if xmlFile ~= nil then
                LowerReverseBeepVol.VolumeState = xmlFile:getInt("LowerReverseBeepVol.RBVolumeState", LowerReverseBeepVol.VolumeState)
                xmlFile:delete()
				LowerReverseBeepVol.XMLloaded = 1
				state = LowerReverseBeepVol.VolumeState
				if state == 1 then
					LowerReverseBeepVol.Volume = -1000
				elseif state == 2 then
					LowerReverseBeepVol.Volume = 1 / 100
				elseif state == 3 then
					LowerReverseBeepVol.Volume = 2.5 / 100
				elseif state == 4 then
					LowerReverseBeepVol.Volume = 5 / 100
				elseif state == 5 then
					LowerReverseBeepVol.Volume = 10 / 100
				elseif state == 6 then
					LowerReverseBeepVol.Volume = 25 / 100
				elseif state == 7 then
					LowerReverseBeepVol.Volume = 50 / 100
				elseif state == 8 then
					LowerReverseBeepVol.Volume = 75 / 100
				elseif state == 9 then
					LowerReverseBeepVol.Volume = 100 / 100
				elseif state == 10 then
					LowerReverseBeepVol.Volume = 150 / 100
				elseif state == 11 then
					LowerReverseBeepVol.Volume = 200 / 100
				end
				print("LRBV: LowerReverseBeepVol.xml data loaded")
				print("LRBV: LowerReverseBeepVol.xml Volume: ".. tostring(LowerReverseBeepVol.Volume))
				print("LRBV: LowerReverseBeepVol.xml VolumeState: ".. tostring(LowerReverseBeepVol.VolumeState))
				print("LRBV: LowerReverseBeepVol.xml State: ".. tostring(state))
			else
				LowerReverseBeepVol.XMLloaded = 2
				LowerReverseBeepVol.VolumeState = 4
				LowerReverseBeepVol.Volume = 5 / 100
				print("LRBV: LowerReverseBeepVol.xml data NOT loaded")
            end
		end
	end
end

function LowerReverseBeepVol:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    local spec = self.spec_motorized
	
    if self:getIsMotorStarted() then
        if self.isClient then
			LowerReverseBeepVol.Volume = 5 / 100
            local samples = spec.samples
			if samples.reverseDrive ~= nil then
			samples.reverseDrive.volumeScale = 0.3 -- 30 % volume
				g_soundManager:setSampleVolumeOffset(samples.reverseDrive, LowerReverseBeepVol.Volume)
				-- print ("Vol Set:" .. tostring(LowerReverseBeepVol.Volume))
				-- print ("reverseDrive:" .. tostring(samples.reverseDrive))
				-- print ("volume:" .. tostring(samples.reverseDrive.volume))
				-- print ("volumeScale:" .. tostring(samples.reverseDrive.volumeScale))
				
				-- DebugUtil.printTableRecursively(self.spec_motorized.motor, "motor- " , 0, 4)
				if PTR == false then
					-- DebugUtil.printTableRecursively(self.spec_motorized.samples.reverseDrive, "samples- " , 0, 6)
					PTR = true
				end
			end
        end
    end
end
Motorized.onUpdate = Utils.appendedFunction(Motorized.onUpdate, LowerReverseBeepVol.onUpdate)

if LowerReverseBeepVol.ModName == nil then 
	LowerReverseBeepVol.ModName = g_currentModName
end
if LowerReverseBeepVol.ModDir == nil then
	LowerReverseBeepVol.ModDir = g_currentModDirectory
end

-- LowerReverseBeepVol.Volume = 1;
-- LowerReverseBeepVol.VolumeState = 4;
-- LowerReverseBeepVol.XMLloaded = 0;
-- LowerReverseBeepVol.VolumeChanged = {}
-- LowerReverseBeepVol.VolumeChanged[1] = g_i18n.modEnvironments[LowerReverseBeepVol.ModName]:getText("selection_LowerReverseBeepVol_0")
-- LowerReverseBeepVol.VolumeChanged[2] = g_i18n.modEnvironments[LowerReverseBeepVol.ModName]:getText("selection_LowerReverseBeepVol_1")
-- LowerReverseBeepVol.VolumeChanged[3] = g_i18n.modEnvironments[LowerReverseBeepVol.ModName]:getText("selection_LowerReverseBeepVol_2.5")
-- LowerReverseBeepVol.VolumeChanged[4] = g_i18n.modEnvironments[LowerReverseBeepVol.ModName]:getText("selection_LowerReverseBeepVol_5")
-- LowerReverseBeepVol.VolumeChanged[5] = g_i18n.modEnvironments[LowerReverseBeepVol.ModName]:getText("selection_LowerReverseBeepVol_10")
-- LowerReverseBeepVol.VolumeChanged[6] = g_i18n.modEnvironments[LowerReverseBeepVol.ModName]:getText("selection_LowerReverseBeepVol_25")
-- LowerReverseBeepVol.VolumeChanged[7] = g_i18n.modEnvironments[LowerReverseBeepVol.ModName]:getText("selection_LowerReverseBeepVol_50")
-- LowerReverseBeepVol.VolumeChanged[8] = g_i18n.modEnvironments[LowerReverseBeepVol.ModName]:getText("selection_LowerReverseBeepVol_75")
-- LowerReverseBeepVol.VolumeChanged[9] = g_i18n.modEnvironments[LowerReverseBeepVol.ModName]:getText("selection_LowerReverseBeepVol_100")
-- LowerReverseBeepVol.VolumeChanged[10] = g_i18n.modEnvironments[LowerReverseBeepVol.ModName]:getText("selection_LowerReverseBeepVol_150")
-- LowerReverseBeepVol.VolumeChanged[11] = g_i18n.modEnvironments[LowerReverseBeepVol.ModName]:getText("selection_LowerReverseBeepVol_200")

-- function init()
	-- InGameMenuGameSettingsFrame.onFrameOpen = Utils.appendedFunction(InGameMenuGameSettingsFrame.onFrameOpen, LowerReverseBeepVol.installGUI)
    -- InGameMenuGameSettingsFrame.updateGameSettings = Utils.appendedFunction(InGameMenuGameSettingsFrame.updateGameSettings, LowerReverseBeepVol.updateLowerReverseBeepVolGui)
-- end

-- function LowerReverseBeepVol.saveToXMLFile(mission)
    -- if g_currentMission.missionInfo.isValid then
		-- local spec = spec_RFP
        -- local xmlFile = XMLFile.create("LowerReverseBeepVol", g_currentMission.missionInfo.savegameDirectory .. "/LowerReverseBeepVol.xml", "LowerReverseBeepVol")
        -- if xmlFile ~= nil then
            -- xmlFile:setInt("LowerReverseBeepVol.RBVolumeState", LowerReverseBeepVol.VolumeState)
            -- xmlFile:save()
            -- xmlFile:delete()
			-- print("LRBV: LowerReverseBeepVol.xml data saved")
        -- end
    -- end
-- end

-- function LowerReverseBeepVol:installGUI()
	-- if not self.initLRBVGuiDone then 
		
		-- local title = TextElement.new()
		-- title:applyProfile("settingsMenuSubtitle", true)
		-- title:setText(g_i18n:getText("title_LowerReverseBeepVol"))
		-- self.boxLayout:addElement(title)
		-- self.LRBVolume = self.checkDirt:clone()
		-- self.LRBVolume.target = LowerReverseBeepVol 
		-- self.LRBVolume.id = "LRBVolume"
		-- self.LRBVolume:setCallback("onClickCallback", "onLowerReverseBeepVolVolumeChanged")
		-- self.LRBVolume.elements[4]:setText(g_i18n:getText("setting_LowerReverseBeepVol_Volume"))
		-- self.LRBVolume.elements[6]:setText(g_i18n:getText("explanation_LowerReverseBeepVol_Volume"))
		-- self.LRBVolume:setTexts({g_i18n:getText("selection_LowerReverseBeepVol_0"), g_i18n:getText("selection_LowerReverseBeepVol_1"), g_i18n:getText("selection_LowerReverseBeepVol_2.5"), g_i18n:getText("selection_LowerReverseBeepVol_5"), g_i18n:getText("selection_LowerReverseBeepVol_10"), g_i18n:getText("selection_LowerReverseBeepVol_25"), g_i18n:getText("selection_LowerReverseBeepVol_50"), g_i18n:getText("selection_LowerReverseBeepVol_75"), g_i18n:getText("selection_LowerReverseBeepVol_100"), g_i18n:getText("selection_LowerReverseBeepVol_150"), g_i18n:getText("selection_LowerReverseBeepVol_200")})
		-- self.boxLayout:addElement(self.LRBVolume)
		-- self.initLRBVGuiDone = true
		-- self.LRBVolume:setState(LowerReverseBeepVol.VolumeState)
	-- end
-- end

-- function LowerReverseBeepVol.updateLowerReverseBeepVolGui(self)
	-- if self.initLRBVGuiDone and self.LRBVolume ~= nil then
        -- self.LRBVolume:setState(LowerReverseBeepVol.VolumeState)
    -- end
-- end

-- function LowerReverseBeepVol:onLowerReverseBeepVolVolumeChanged(state)
	-- LowerReverseBeepVol.VolumeState = state;
	-- if state == 1 then
		-- LowerReverseBeepVol.Volume = -1000
	-- elseif state == 2 then
		-- LowerReverseBeepVol.Volume = 1 / 100
	-- elseif state == 3 then
		-- LowerReverseBeepVol.Volume = 2.5 / 100
	-- elseif state == 4 then
		-- LowerReverseBeepVol.Volume = 5 / 100
	-- elseif state == 5 then
		-- LowerReverseBeepVol.Volume = 10 / 100
	-- elseif state == 6 then
		-- LowerReverseBeepVol.Volume = 25 / 100
	-- elseif state == 7 then
		-- LowerReverseBeepVol.Volume = 50 / 100
	-- elseif state == 8 then
		-- LowerReverseBeepVol.Volume = 75 / 100
	-- elseif state == 9 then
		-- LowerReverseBeepVol.Volume = 100 / 100
	-- elseif state == 10 then
		-- LowerReverseBeepVol.Volume = 150 / 100
	-- elseif state == 11 then
		-- LowerReverseBeepVol.Volume = 200 / 100
	-- end
	-- g_currentMission:addGameNotification(g_i18n.modEnvironments[LowerReverseBeepVol.ModName]:getText("SettingChanged_title"), g_i18n.modEnvironments[LowerReverseBeepVol.ModName]:getText("SettingChanged").." "..LowerReverseBeepVol.VolumeChanged[state], "", 2500)
-- end
-- init()
-- -- make localizations available
-- local i18nTable = getfenv(0).g_i18n
-- for l18nId,l18nText in pairs(g_i18n.texts) do
  -- i18nTable:setText(l18nId, l18nText)
-- end

if LowerReverseBeepVol.loaded == nil then
    LowerReverseBeepVol.loaded = true
    Mission00.loadMission00Finished = Utils.appendedFunction(Mission00.loadMission00Finished, LowerReverseBeepVol.loadedMission);
    -- FSCareerMissionInfo.saveToXMLFile = Utils.appendedFunction(FSCareerMissionInfo.saveToXMLFile, LowerReverseBeepVol.saveToXMLFile);
    -- FSBaseMission.onConnectionFinishedLoading = Utils.appendedFunction(FSBaseMission.onConnectionFinishedLoading, LowerReverseBeepVol.loadSettingsForClient)
end