-- LOC_drawFundsDialog.lua
-- Line of Credit mod - Draw Funds dialog

LOC_drawFundsDialog = {}
local LOC_drawFundsDialog_mt = Class(LOC_drawFundsDialog, MessageDialog)

function LOC_drawFundsDialog.new(target, customMt)
    local self = MessageDialog.new(target, customMt or LOC_drawFundsDialog_mt)
    self.creditLineManager = nil -- Will be set when showing dialog
    self.callback = nil
    self.creditLine = nil
    return self
end

function LOC_drawFundsDialog:onCreate()
    -- Get elements by ID using getDescendantById
    self.drawAmountInput = self:getDescendantById("drawAmountInput")
    self.availableBalanceField = self:getDescendantById("availableBalanceField")
    self.newBalanceField = self:getDescendantById("newBalanceField")
    self.interestRateField = self:getDescendantById("interestRateField")
end

function LOC_drawFundsDialog:onOpen()
    MessageDialog.onOpen(self)
    
    if self.drawAmountInput then
        self.drawAmountInput:setText("")
        FocusManager:setFocus(self.drawAmountInput)
    end
    
    self:updateInfoDisplay()
end

function LOC_drawFundsDialog:setCreditLine(creditLine, creditLineManager)
    self.creditLine = creditLine
    self.creditLineManager = creditLineManager
end

function LOC_drawFundsDialog:setCallback(callback)
    self.callback = callback
end

function LOC_drawFundsDialog:onTextChanged(element, text)
    if element == self.drawAmountInput then
        self:updateInfoDisplay()
    end
end

function LOC_drawFundsDialog:updateInfoDisplay()
    if not self.creditLine then
        return
    end
    
    local drawAmountText = self.drawAmountInput and self.drawAmountInput:getText() or ""
    local drawAmount = tonumber(drawAmountText) or 0
    
    -- Update available balance
    local availableBalance = self.creditLine.creditLimit - self.creditLine.currentBalance
    if self.availableBalanceField then
        self.availableBalanceField:setText(string.format("Available: $%s", 
            g_i18n:formatMoney(availableBalance)))
    end
    
    -- Update new balance after draw
    local newBalance = self.creditLine.currentBalance + drawAmount
    if self.newBalanceField then
        if drawAmount > 0 and drawAmount <= availableBalance then
            self.newBalanceField:setText(string.format("New Balance: $%s", 
                g_i18n:formatMoney(newBalance)))
            self.newBalanceField:setTextColor(1, 1, 1, 1)
        elseif drawAmount > availableBalance then
            self.newBalanceField:setText("Amount exceeds available balance!")
            self.newBalanceField:setTextColor(1, 0.2, 0.2, 1)
        else
            self.newBalanceField:setText("New Balance: --")
            self.newBalanceField:setTextColor(1, 1, 1, 1)
        end
    end
    
    -- Update interest rate display
    if self.interestRateField then
        local rate = self.creditLine.currentInterestRate or self.creditLine.interestRate or 0.06
        self.interestRateField:setText(string.format("Interest Rate: %.1f%%", rate * 100))
    end
end

function LOC_drawFundsDialog:onEnterPressed(element)
    if element == self.drawAmountInput then
        self:onClickOk()
    end
end

function LOC_drawFundsDialog:onClickOk()
    local drawAmountText = self.drawAmountInput and self.drawAmountInput:getText() or ""
    local drawAmount = tonumber(drawAmountText)
    
    if not drawAmount or drawAmount <= 0 then
        g_gui:showInfoDialog({
            text = "Please enter a valid amount to draw."
        })
        return
    end
    
    local availableBalance = self.creditLine.creditLimit - self.creditLine.currentBalance
    if drawAmount > availableBalance then
        g_gui:showInfoDialog({
            text = string.format("Amount exceeds available balance of $%s", 
                g_i18n:formatMoney(availableBalance))
        })
        return
    end
    
    self:close()
    
    if self.callback then
        self.callback(drawAmount)
    end
end

function LOC_drawFundsDialog:onClickCancel()
    self:close()
end