-- Line of Credit Create Credit Line Event
-- Network event for creating credit lines in multiplayer
-- Author: sockswayup

LOC_createCreditLineEvent = {}

local LOC_createCreditLineEvent_mt = Class(LOC_createCreditLineEvent, Event)

InitEventClass(LOC_createCreditLineEvent, "LOC_createCreditLineEvent")

function LOC_createCreditLineEvent.emptyNew()
    local self = Event.new(LOC_createCreditLineEvent_mt)
    return self
end

function LOC_createCreditLineEvent.new(farmId, creditLimit, interestRate, paymentTermYears)
    local self = LOC_createCreditLineEvent.emptyNew()
    
    self.farmId = farmId or 1
    self.creditLimit = creditLimit or 0
    self.interestRate = interestRate or 0.06
    self.paymentTermYears = paymentTermYears or 10
    
    return self
end

function LOC_createCreditLineEvent:readStream(streamId, connection)
    self.farmId = streamReadInt32(streamId, 0)
    self.creditLimit = streamReadFloat32(streamId)
    self.interestRate = streamReadFloat32(streamId)
    self.paymentTermYears = streamReadInt32(streamId)
    self:run(connection)
end

function LOC_createCreditLineEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, self.farmId, 0)
    streamWriteFloat32(streamId, self.creditLimit)
    streamWriteFloat32(streamId, self.interestRate)
    streamWriteInt32(streamId, self.paymentTermYears)
end

function LOC_createCreditLineEvent:run(connection)
    if not connection:getIsServer() then
        -- This runs on the server when received from client
        print("[Line of Credit] Server received create credit line request for farm " .. self.farmId)
        
        if g_loc_manager then
            -- Create the credit line on the server
            local creditLine = LOC_creditLine.new(true, false) -- server only
            creditLine:init(self.farmId, self.creditLimit, self.interestRate, self.paymentTermYears, g_loc_manager.properties.dynamicInterestRate)
            
            -- Register it in the server's manager
            g_loc_manager:addCreditLine(creditLine)
            
            print("[Line of Credit] Credit line created on server for farm " .. self.farmId .. " with limit " .. self.creditLimit)
            
            -- Force immediate save to test
            LOC_manager.saveToXMLFile(g_currentMission.missionInfo)
        end
    end
end