-- Line of Credit Add/Remove Money Event
-- Network event for handling money changes in multiplayer
-- Author: sockswayup

LOC_addRemoveMoneyEvent = {}

local LOC_addRemoveMoneyEvent_mt = Class(LOC_addRemoveMoneyEvent, Event)

InitEventClass(LOC_addRemoveMoneyEvent, "LOC_addRemoveMoneyEvent")

function LOC_addRemoveMoneyEvent.emptyNew()
    local self = Event.new(LOC_addRemoveMoneyEvent_mt)
    return self
end

function LOC_addRemoveMoneyEvent.new(amount, farmId, moneyType, description)
    local self = LOC_addRemoveMoneyEvent.emptyNew()
    
    self.amount = amount or 0
    self.farmId = farmId or 1
    self.moneyTypeId = (moneyType and moneyType.id) or MoneyType.OTHER.id
    self.description = description or "Line of Credit Transaction"
    
    return self
end

function LOC_addRemoveMoneyEvent:readStream(streamId, connection)
    self.amount = streamReadInt32(streamId)
    self.farmId = streamReadInt32(streamId, 0)
    self.moneyTypeId = streamReadInt32(streamId, MoneyType.OTHER.id)
    self.description = streamReadString(streamId)
    self:run(connection)
end

function LOC_addRemoveMoneyEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, self.amount)
    streamWriteInt32(streamId, self.farmId, 0)
    streamWriteInt32(streamId, self.moneyTypeId, MoneyType.OTHER.id)
    streamWriteString(streamId, self.description)
end

function LOC_addRemoveMoneyEvent:run(connection)
    if not connection:getIsServer() then
        -- This runs on the server when received from client
        if g_loc_manager then
            local moneyType = MoneyType.getMoneyTypeById(self.moneyTypeId)
            -- Call the manager's addRemoveMoney function which will handle the actual money changes
            -- But we need to call the server-side logic directly to avoid infinite recursion
            if g_currentMission:getIsServer() then
                g_currentMission:addMoneyChange(self.amount, self.farmId, moneyType, true, true)
                
                local farm = g_farmManager:getFarmById(self.farmId)
                if farm ~= nil then
                    farm:changeBalance(self.amount, moneyType)
                end
            end
        end
    end
end
