-- Line of Credit Manager - Main Entry Point
-- Author: sockswayup
-- Version: 1.0.4.0
-- Based on Enhanced Loan System pattern

local modDirectory = g_currentModDirectory

-- Load core components
source(g_currentModDirectory .. "src/LOC_creditLine.lua")
source(g_currentModDirectory .. "src/LOC_manager.lua")
source(g_currentModDirectory .. "src/LOC_properties.lua")
source(g_currentModDirectory .. "src/LOC_addRemoveMoneyEvent.lua")
source(g_currentModDirectory .. "src/LOC_createCreditLineEvent.lua")

source(g_currentModDirectory .. "src/gui/LOC_inGameMenuCredit.lua")
source(g_currentModDirectory .. "src/gui/LOC_applyCreditDialog.lua")
source(g_currentModDirectory .. "src/gui/LOC_drawFundsDialog.lua")
source(g_currentModDirectory .. "src/gui/LOC_makePaymentDialog.lua")

-- Register the manager as event listener
addModEventListener(LOC_manager)

function loadedMission()
    local guiCreditSystem = LOC_inGameMenuCredit.new(g_i18n, g_messageCenter)
    g_gui:loadGui(modDirectory.."gui/LOC_inGameMenuCredit.xml", "InGameMenuCreditSystem", guiCreditSystem, true)
    
    -- Load apply credit dialog
    local applyCreditDialog = LOC_applyCreditDialog.new(nil, nil, g_i18n)
    g_gui:loadGui(modDirectory.."gui/LOC_applyCreditDialog.xml", "LOC_applyCreditDialog", applyCreditDialog)
    
    -- Load draw funds dialog  
    local drawFundsDialog = LOC_drawFundsDialog.new(nil, nil)
    g_gui:loadGui(modDirectory.."gui/LOC_drawFundsDialog.xml", "LOC_drawFundsDialog", drawFundsDialog)
    g_locDrawFundsDialog = drawFundsDialog  -- Store global reference
    
    -- Load make payment dialog
    local makePaymentDialog = LOC_makePaymentDialog.new(nil, nil)
    g_gui:loadGui(modDirectory.."gui/LOC_makePaymentDialog.xml", "LOC_makePaymentDialog", makePaymentDialog)
    g_locMakePaymentDialog = makePaymentDialog  -- Store global reference
    
    fixInGameMenu(guiCreditSystem, "InGameMenuCreditSystem", {0,0,1024,1024}, 4, nil)
    
    guiCreditSystem:initialize()
end

function onStartMission()
    -- Initialize credit system on server
    if g_currentMission:getIsServer() then
        -- Register event listeners for payment processing
        if g_loc_manager and g_loc_manager.loadMap then
            g_loc_manager:loadMap()
        end
    end
    
    -- Hook HUD drawing
    if g_currentMission.hud then
        g_currentMission.hud.draw = Utils.appendedFunction(g_currentMission.hud.draw, function()
            if g_locHudDisplay then
                g_locHudDisplay:draw()
            end
        end)
    end
    
    -- Add key binding for HUD toggle (F7) --- I think this needs removed
    if g_currentMission.inputManager then
        local _, eventId = g_currentMission.inputManager:registerActionEvent(InputAction.MENU_EXTRA_2, InputBinding.NO_EVENT_TARGET, function()
            if g_locHudDisplay then
                g_locHudDisplay:toggle()
                g_currentMission:addIngameNotification(FSBaseMission.INGAME_NOTIFICATION_INFO, 
                    g_locHudDisplay.visible and "Line of Credit HUD: ON" or "Line of Credit HUD: OFF")
            end
        end, false, true, false, true)
    end
end

function fixInGameMenu(frame, pageName, uvs, position, predicateFunc)
    local inGameMenu = g_gui.screenControllers[InGameMenu]
    
    if not inGameMenu then
        return
    end
    
    -- Remove to avoid warnings --- I think this needs removed as well.
    if inGameMenu.controlIDs then
        for k, v in pairs({pageName}) do
            inGameMenu.controlIDs[v] = nil
        end
    end
    
    inGameMenu[pageName] = frame
    
    -- I think this needs removed as well.
    if inGameMenu.pagingElement and inGameMenu.pagingElement.addElement then
        inGameMenu.pagingElement:addElement(inGameMenu[pageName])
    else
        print("[Line of Credit] Warning: pagingElement not available")
        return
    end
    
    inGameMenu:exposeControlsAsFields(pageName)
    
    -- Reorder elements
    if inGameMenu.pagingElement and inGameMenu.pagingElement.elements then
        for i = 1, #inGameMenu.pagingElement.elements do
            local child = inGameMenu.pagingElement.elements[i]
            if child == inGameMenu[pageName] then
                table.remove(inGameMenu.pagingElement.elements, i)
                table.insert(inGameMenu.pagingElement.elements, position, child)
                break
            end
        end
    end
    
    if inGameMenu.pagingElement and inGameMenu.pagingElement.pages then
        for i = 1, #inGameMenu.pagingElement.pages do
            local child = inGameMenu.pagingElement.pages[i]
            if child and child.element == inGameMenu[pageName] then
                table.remove(inGameMenu.pagingElement.pages, i)
                table.insert(inGameMenu.pagingElement.pages, position, child)
                break
            end
        end
    end
    
    inGameMenu.pagingElement:updateAbsolutePosition()
    inGameMenu.pagingElement:updatePageMapping()
    
    inGameMenu:registerPage(inGameMenu[pageName], position, predicateFunc)
    local iconFileName = Utils.getFilename('images/icon.dds', modDirectory)
    inGameMenu:addPageTab(inGameMenu[pageName], iconFileName, GuiUtils.getUVs(uvs))
    
    for i = 1, #inGameMenu.pageFrames do
        local child = inGameMenu.pageFrames[i]
        if child == inGameMenu[pageName] then
            table.remove(inGameMenu.pageFrames, i)
            table.insert(inGameMenu.pageFrames, position, child)
            break
        end
    end
    
    inGameMenu:rebuildTabList()
end

-- Console command for manual sync (debugging)
addConsoleCommand("locSync", "Manually sync Line of Credit data to all clients", "consoleCommandSyncLOC", nil)

function consoleCommandSyncLOC()
    if g_currentMission:getIsServer() then
        print("[Line of Credit] Manual sync triggered via console")
        LOC_manager.syncAllCreditLinesToClients()
        return "Line of Credit data synced to all clients"
    else
        return "This command can only be run on the server"
    end
end

function init()
    -- Hook into mission lifecycle
    Mission00.loadMission00Finished = Utils.appendedFunction(Mission00.loadMission00Finished, loadedMission)
    Mission00.onStartMission = Utils.appendedFunction(Mission00.onStartMission, onStartMission)
    
    -- Hook save/load exactly like ELS does
    Mission00.loadItemsFinished = Utils.appendedFunction(Mission00.loadItemsFinished, LOC_manager.loadFromXMLFile)
    FSCareerMissionInfo.saveToXMLFile = Utils.appendedFunction(FSCareerMissionInfo.saveToXMLFile, LOC_manager.saveToXMLFile)
    Mission00.loadAdditionalFilesFinished = Utils.appendedFunction(Mission00.loadAdditionalFilesFinished, LOC_manager.loadMapData)
end

init()

