VacationManager = {};

VacationManager.IconBaseDir = g_currentModDirectory.."Palm.dds";
VacationManager.IconAnimDir = g_currentModDirectory.."Ball.dds";

function VacationManager:onSleepRequest(OldFunc, UserId, Time)
    if Time > 0 then
        return OldFunc(self, UserId, Time);
    end

    local PlayerI = g_currentMission.userManager:getUserByUserId(UserId)
	local Name = PlayerI == nil and "Unknown" or PlayerI:getNickname()
	
    self.isSleepRequestAnswerPending = true

    local Text = string.format(g_i18n:getText("text_VacationRequest"), Name, VacationDialog:GetTextBySkipDays(math.abs(Time)))

	YesNoDialog.show(self.onSleepRequestYesNo, self, Text)
end

function VacationManager:startSleep(OldFunc, Time)

    VacationManager.VacationRender = Time < 0;

    if Time < 0 and g_currentMission:getIsServer() then

        local Wakeup = VacationDialog:GetDataBySkipDays(math.abs(Time))

        VacationManager.WakeupPeriod = Wakeup.Period;
        VacationManager.WakeupDay = Wakeup.Day;
        VacationManager.WakeupHour = 7;
    
        local Ret = OldFunc(self, Time);
    
        g_sleepManager.wakeUpTime = 0
    
        return Ret;
    end

    return OldFunc(self, Time);
end

function VacationManager:stopSleep(OldFunc, ...)

    if VacationManager.WakeupPeriod == nil then
        return OldFunc(self, ...);
    end

    if Input.isKeyPressed(Input.KEY_delete) then
        VacationManager.WakeupPeriod = nil;
        VacationManager.WakeupDay = nil;
        VacationManager.WakeupHour = nil;

        return OldFunc(self, ...);
    end

    if g_currentMission.environment.currentPeriod == VacationManager.WakeupPeriod then
        if g_currentMission.environment.currentDayInPeriod == VacationManager.WakeupDay then
            if g_currentMission.environment.currentHour >= VacationManager.WakeupHour then

                VacationManager.WakeupPeriod = nil;
                VacationManager.WakeupDay = nil;
                VacationManager.WakeupHour = nil;

                return OldFunc(self, ...);
            end
        end
    end
end

function VacationManager:draw(OldFunc, ...)
    if VacationManager.VacationRender == false then
        return OldFunc(self, ...);
    end

    local function oscillate(elapsedTimeMs, minValue, maxValue, duration)
        local elapsedSeconds = elapsedTimeMs / 1000    
        local range = maxValue - minValue
        local center = minValue + range / 2
        local amplitude = range / 2
        local oscillation = math.sin((elapsedSeconds * 2 * math.pi) / duration)
        local result = center + oscillation * amplitude
        return result
    end

    if self.isSleeping and not g_currentMission.paused then
		if self.animationBackgroundOverlay ~= nil then
			self.animationBackgroundOverlay:render()
		end

        if VacationManager.IconBaseOverlay ~= nil and VacationManager.IconAnimOverlay ~= nil then
			VacationManager.IconBaseOverlay:render()
			VacationManager.IconAnimOverlay:render()

            VacationManager.IconAnimOverlay:setPosition(oscillate(g_time,0.493,0.507,1.3), 0.5)
		end
	end
end

function VacationManager:loadMapData(OldFunc, ...)

    local x, y = getNormalizedScreenValues(165, 165)

    VacationManager.IconBaseOverlay = Overlay.new(VacationManager.IconBaseDir, 0.5, 0.5, x, y)
	VacationManager.IconBaseOverlay:setAlignment(Overlay.ALIGN_VERTICAL_MIDDLE, Overlay.ALIGN_HORIZONTAL_CENTER)
	VacationManager.IconBaseOverlay:setColor(0.22323, 0.40724, 0.00368, 1)

    VacationManager.IconAnimOverlay = Overlay.new(VacationManager.IconAnimDir, 0.5, 0.5, x, y)
	VacationManager.IconAnimOverlay:setAlignment(Overlay.ALIGN_VERTICAL_MIDDLE, Overlay.ALIGN_HORIZONTAL_CENTER)
	VacationManager.IconAnimOverlay:setColor(0.22323, 0.40724, 0.00368, 1)

    return OldFunc(self, ...);
end

SleepManager.onSleepRequest = Utils.overwrittenFunction(SleepManager.onSleepRequest, VacationManager.onSleepRequest);
SleepManager.startSleep = Utils.overwrittenFunction(SleepManager.startSleep, VacationManager.startSleep);
SleepManager.stopSleep = Utils.overwrittenFunction(SleepManager.stopSleep, VacationManager.stopSleep);
SleepManager.draw = Utils.overwrittenFunction(SleepManager.draw, VacationManager.draw);
SleepManager.loadMapData = Utils.overwrittenFunction(SleepManager.loadMapData, VacationManager.loadMapData);

