GoToVacation = {};

function GoToVacation:VacationDialogButton(Yes, Period, Day, SkipDays)
	if not Yes then return end

	if g_currentMission:getIsServer() then
		g_sleepManager:startSleepRequest(g_currentMission.playerUserId, -SkipDays)
		return
	end

	g_client:getServerConnection():sendEvent(SleepRequestEvent.new(g_currentMission.playerUserId, -SkipDays))
end

function GoToVacation:VacationActionButton()
	VacationDialog:show(GoToVacation.VacationDialogButton);
end

function GoToVacation:UpdateActionEvent(Active)
	if GoToVacation.VacationActionId == nil then
		local valid, EventId = g_inputBinding:registerActionEvent(InputAction.VacationAction, "VacationAction", GoToVacation.VacationActionButton, false, true, false, false);
		if valid then GoToVacation.VacationActionId = EventId end
	end

	g_inputBinding:setActionEventTextPriority(GoToVacation.VacationActionId, GS_PRIO_VERY_HIGH)
	g_inputBinding:setActionEventActive(GoToVacation.VacationActionId, Active);
end

function GoToVacation:SleepingTriggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
	if g_localPlayer ~= nil and otherActorId == g_localPlayer.rootNode then
		GoToVacation:UpdateActionEvent(onEnter)
	end
end

PlaceableFarmhouse.farmhouseSleepingTriggerCallback = Utils.appendedFunction(PlaceableFarmhouse.farmhouseSleepingTriggerCallback, GoToVacation.SleepingTriggerCallback)
addModEventListener(GoToVacation);