-- FreeFences for Free Fence Placement
FreeFences = {}
FreeFences.Debug = false  -- Enable debug for easier troubleshooting


FreeFences.metadata = {
    title = "FreeFencePlacement",
    author = "thatSepticGuy",
    info = "Not to be replicated. Makes fences free."
}
FreeFences.modDir = g_currentModDirectory


function FreeFences.DebugText(text, ...)
    if not FreeFences.Debug then return end
    print("FreeFencesDebug: " .. string.format(text, ...))
end

function FreeFences.getCost(superfunc, fencePlaceable, displacedVolumeOrArea)
    if FreeFences.Debug then
        FreeFences.DebugText("Making fence placement free.")
    end
    
    return 0
end


if FenceSegment then
    function FenceSegment:getPrice(superfunc)
        if FreeFences.Debug then
            FreeFences.DebugText("FenceSegment price set to 0 for free placement.")
        end
        return 0
    end
end

if FenceGate then
    function FenceGate:getPrice(superfunc)
        if FreeFences.Debug then
            FreeFences.DebugText("FenceSegment price set to 0 for free placement.")
        end
        return 0
    end
end


if FencePlaceable then
    FencePlaceable.getCost = Utils.overwrittenFunction(FencePlaceable.getCost, FreeFences.getCost)
end

if FreeFences.Debug then
    FreeFences.DebugText("FreeFencePlacement mod loaded and cost overridden.")
end





