
local growthSpeedFactor = 0.5

local originalLoadTreeTypes = TreePlantManager.loadTreeTypes

function TreePlantManager:loadTreeTypes(xmlFile, missionInfo, baseDirectory, isBaseType, customEnvironment)

    local result = originalLoadTreeTypes(self, xmlFile, missionInfo, baseDirectory, isBaseType, customEnvironment)
    
    for _, treeType in ipairs(self.treeTypes) do
        if treeType.growthTimeHours ~= nil then

            local newTime = treeType.growthTimeHours * growthSpeedFactor

            treeType.growthTimeHours = math.max(newTime, 0.1)
        end
    end
    
    return result
end