--
-- Easy Arm Controls Toggle for FS25
-- @author:    	kenny456 (kenny456@seznam.cz)
-- @history:	v1.0 - 2024-11-16 - conversion to FS25
--
EasyArmControlToggle = {};
EasyArmControlToggle.confDir = getUserProfileAppPath().. "modsSettings/EasyArmControlToggle/";
EasyArmControlToggle.modDirectory = g_currentModDirectory
local modName = g_currentModName

function EasyArmControlToggle.prerequisitesPresent(specializations)
	return true
end
function EasyArmControlToggle.registerOverwrittenFunctions(vehicleType)
	--SpecializationUtil.registerOverwrittenFunction(vehicleType, "processMowerArea", 		EasyArmControlToggle.processMowerArea)
end
function EasyArmControlToggle.registerFunctions(vehicleType)
	SpecializationUtil.registerFunction(vehicleType, "eacToggleActive", 						EasyArmControlToggle.eacToggleActive)
end
function EasyArmControlToggle:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
	local spec = self.spec_easyArmControlToggle
	if not spec.modInitialized then
		return
	end
	
	if g_dedicatedServerInfo ~= nil then
		return
	end
	if spec.event_IDs == nil then
		spec.event_IDs = {}
	end
	if self:getIsActiveForInput() or (self.getIscontrolled ~= nil and self:getIsControlled()) then
		--print(self:getFullName()..'enter')
		local easyArmControl = self.spec_cylindered.easyArmControl
        if easyArmControl ~= nil then
			if spec.modActive ~= g_gameSettings:getValue("easyArmControl") then
				--print('----------------------------------------------------------------------'..self:getFullName()..' register - modActive - '..tostring(spec.modActive))
				self:eacToggleActive(spec.modActive, false)
			end
			local actions = { InputAction.EASYARMCONTROLTOGGLE_ACTIVATE }

			for _,actionName in pairs(actions) do
				local always = (actionName == InputAction.REALSHOVEL_MENU_PLUS or actionName == InputAction.REALSHOVEL_MENU_MINUS) and true or false
				local _, eventID = g_inputBinding:registerActionEvent(actionName, self, EasyArmControlToggle.actionCallback, true, true, always, true)
				spec.event_IDs[actionName] = eventID
				if g_inputBinding ~= nil and g_inputBinding.events ~= nil and g_inputBinding.events[eventID] ~= nil then
					if actionName == 'something with lower priority' then
						g_inputBinding:setActionEventTextPriority(eventID, GS_PRIO_NORMAL)
					else
						g_inputBinding:setActionEventTextPriority(eventID, GS_PRIO_VERY_HIGH)
					end
					if actionName == InputAction.EASYARMCONTROLTOGGLE_TOGGLE_HELP then
						g_inputBinding:setActionEventTextVisibility(eventID, true)
					elseif actionName == InputAction.EASYARMCONTROLTOGGLE_TOGGLE then
						g_inputBinding:setActionEventTextVisibility(eventID, false)
					else
						g_inputBinding:setActionEventTextVisibility(eventID, EasyArmControlToggle.showHelp)
					end
				end
				local colliding = false
				_, colliding, _ = g_inputBinding:checkEventCollision(actionName)
				if colliding then
					if g_inputBinding.nameActions[actionName].bindings[1] ~= nil then
						if g_inputBinding.nameActions[actionName].bindings[1].inputString ~= nil then
							print(string.format('Warning: EasyArmControlToggle got a colliding input action: %s', actionName)..' ('..g_inputBinding.nameActions[actionName].bindings[1].inputString..'). You can remap it in controls settings')
						end
					else
						print(string.format('Warning: EasyArmControlToggle got a colliding input action: %s', actionName))
					end
				end
			end
		end
	end
end
function EasyArmControlToggle.registerEventListeners(vehicleType)
	for _,n in pairs( { "onLoad", "onPostLoad", "saveToXMLFile", "onUpdate", "onRegisterActionEvents", "eacToggleActive", "onReadStream", "onWriteStream"} ) do
		SpecializationUtil.registerEventListener(vehicleType, n, EasyArmControlToggle)
	end
end
function EasyArmControlToggle:onLoad(savegame)
	self.spec_easyArmControlToggle = {}
	local spec = self.spec_easyArmControlToggle
	
	spec.modInitialized = true
	if not spec.modInitialized then
		print("EasyArmControlToggle Warning: EasyArmControlToggle initialization failed for "..tostring(self:getFullName()).." !")
		return
	end
	spec.event_IDs = {}
	spec.modActive = g_gameSettings:getValue("easyArmControl")
	--print('----------------------------------------------------------------------'..self:getFullName()..' onLoad - modActive - '..tostring(spec.modActive))
	EasyArmControlToggle.showHelp = true
end
function EasyArmControlToggle:onPostLoad(savegame)
	local spec = self.spec_easyArmControlToggle
	if not spec.modInitialized then
		return
	end
	if savegame ~= nil then
		local xmlFile = savegame.xmlFile
		local key = savegame.key.."."..modName..".EasyArmControlToggle"
		spec.modActive = Utils.getNoNil(getXMLBool(xmlFile.handle, key.."#modActive"), spec.modActive)
		--print('----------------------------------------------------------------------'..self:getFullName()..' postLoad - modActive - '..tostring(spec.modActive))
		--self:eacToggleActive(spec.modActive, true)
	end
end
function EasyArmControlToggle:saveToXMLFile(xmlFile, key)
	local spec = self.spec_easyArmControlToggle
	
	setXMLBool(xmlFile.handle, key.."#modActive", spec.modActive)
end
function EasyArmControlToggle:onDelete()
	local spec = self.spec_easyArmControlToggle
	if not spec.modInitialized then
		return
	end
end
function EasyArmControlToggle:onUpdate(dt, vehicle)
	local spec = self.spec_easyArmControlToggle
	
	if not spec.modInitialized then
		return
	end
	if self.isClient then
		if self:getIsActiveForInput() or (self.getIscontrolled ~= nil and self:getIsControlled()) then
			if spec.event_IDs ~= nil and g_dedicatedServerInfo == nil then
				for actionName,eventID in pairs(spec.event_IDs) do
					if actionName == InputAction.EASYARMCONTROLTOGGLE_ACTIVATE then
						g_inputBinding:setActionEventActive(eventID, true)
						g_inputBinding:setActionEventText(eventID, spec.modActive and g_i18n:getText('EASYARMCONTROLTOGGLE_DEACTIVATE') or g_i18n:getText('EASYARMCONTROLTOGGLE_ACTIVATE'))
					end
				end
			end
		end
	end
end
function EasyArmControlToggle:actionCallback(actionName, keyStatus, arg4, arg5, arg6)
	local spec = self.spec_easyArmControlToggle
	
	if not spec.modInitialized then
		return
	end
	if keyStatus > 0 then
		if actionName == 'EASYARMCONTROLTOGGLE_ACTIVATE' then
			spec.modActive = not spec.modActive
			--print('----------------------------------------------------------------------'..self:getFullName()..'  action - modActive - '..tostring(spec.modActive))
			--print('----------------------------------------------------------------------'..self:getFullName()..' setting - '..tostring(g_gameSettings:getValue("easyArmControl")))
			self:eacToggleActive(spec.modActive, false)
			
		end
	end
end
function EasyArmControlToggle:eacToggleActive(modActive, noEventSend)
	local spec = self.spec_easyArmControlToggle
	
	if not spec.modInitialized then
		return
	end
	spec.modActive = modActive
	--print('----------------------------------------------------------------------'..self:getFullName()..'  toggle - modActive - '..tostring(spec.modActive))
	g_gameSettings:setValue("easyArmControl",spec.modActive)
	
	--Cylindered.setIsEasyControlActive(self, modActive)
	--EasyArmControlToggleToggleActiveEvent.sendEvent(self, modActive, noEventSend)
end
function EasyArmControlToggle:onReadStream(streamId, connection)
	local spec = self.spec_easyArmControlToggle
	if not spec.modInitialized then
		return
	end
	
    --local modActive = streamReadBool(streamId)
	if modActive ~= nil then
		--self:eacToggleActive(modActive, true)
	end
end
function EasyArmControlToggle:onWriteStream(streamId, connection)
	local spec = self.spec_easyArmControlToggle
	if not spec.modInitialized then
		return
	end
	
    --streamWriteBool(streamId, spec.modActive)
end

--[[EasyArmControlToggleToggleActiveEvent = {};
EasyArmControlToggleToggleActiveEvent_mt = Class(EasyArmControlToggleToggleActiveEvent, Event)

InitEventClass(EasyArmControlToggleToggleActiveEvent, "EasyArmControlToggleToggleActiveEvent")

function EasyArmControlToggleToggleActiveEvent.emptyNew()
    local self = Event.new(EasyArmControlToggleToggleActiveEvent_mt)
    self.className="EasyArmControlToggleToggleActiveEvent"
    return self
end

function EasyArmControlToggleToggleActiveEvent.new(object, modActive)
	local self = EasyArmControlToggleToggleActiveEvent.emptyNew()
	self.object = object
	self.modActive = modActive
	return self
end

function EasyArmControlToggleToggleActiveEvent:readStream(streamId, connection)
	self.object = NetworkUtil.readNodeObject(streamId)
    self.modActive = streamReadBool(streamId)
    self:run(connection)
end

function EasyArmControlToggleToggleActiveEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.object)
	streamWriteBool(streamId, self.modActive)
end

function EasyArmControlToggleToggleActiveEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object)
	end
	if self.object ~= nil then
		self.object:eacToggleActive(self.modActive, true)
	end
end

function EasyArmControlToggleToggleActiveEvent.sendEvent(vehicle, modActive, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(EasyArmControlToggleToggleActiveEvent.new(vehicle, modActive), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(EasyArmControlToggleToggleActiveEvent.new(vehicle, modActive))
		end
	end
end]]