ConstructionScreenExtension = {}
ConstructionScreenExtension.lightFileName = "data/light.i3d"
ConstructionScreenExtension.modDirectory = g_currentModDirectory


GuiTopDownCamera.ROTATION_MIN_X_NEAR = 0

function ConstructionScreenExtension.registerBrushActionEvents(self, superFunc)
    superFunc(self)

    local _, noCollisonModeId = g_inputBinding:registerActionEvent(InputAction.CU_TOGGLE_NO_COLLISION_MODE, self, ConstructionScreenExtension.onToggleNoCollisionMode, false, true, false, true)
    self.noCollisionModeId = noCollisonModeId
	g_inputBinding:setActionEventTextVisibility(self.noCollisionModeId, true)
	g_inputBinding:setActionEventTextPriority(self.noCollisionModeId, GS_PRIO_VERY_HIGH)
	g_inputBinding:setActionEventText(self.noCollisionModeId, g_i18n:getText("input_activateNoCollisionMode"))
    table.insert(self.brushEvents, noCollisonModeId)

    local _, lightModeId = g_inputBinding:registerActionEvent(InputAction.CU_TOGGLE_LIGHT_MODE, self, ConstructionScreenExtension.onToggleLightMode, false, true, false, true)
    self.lightModeId = lightModeId
	g_inputBinding:setActionEventTextVisibility(self.lightModeId, true)
	g_inputBinding:setActionEventTextPriority(self.lightModeId, GS_PRIO_VERY_HIGH)
	g_inputBinding:setActionEventText(self.lightModeId, g_i18n:getText("input_activateLightMode"))
    table.insert(self.brushEvents, lightModeId)

    ConstructionScreenExtension.loadLightIfNeeded()
end

ConstructionScreen.registerBrushActionEvents = Utils.overwrittenFunction(ConstructionScreen.registerBrushActionEvents, ConstructionScreenExtension.registerBrushActionEvents)

function ConstructionScreenExtension.onClose(self, superFunc)
    g_constructionScreen.noCollisionModeActive = false
    GuiTopDownCamera.COLLISION_MASK = CollisionMask.ALL - CollisionFlag.TRIGGER - CollisionFlag.GROUND_TIP_BLOCKING - CollisionFlag.TERRAIN_DISPLACEMENT

    g_constructionScreen.lightModeActive = false
    if g_constructionScreen.cu_lightId ~= nil then
        setVisibility(g_constructionScreen.cu_lightId, false)
    end

    superFunc(self)
end

ConstructionScreen.onClose = Utils.overwrittenFunction(ConstructionScreen.onClose, ConstructionScreenExtension.onClose)

function ConstructionScreenExtension.removeBrushActionEvents(self, superFunc)
    superFunc(self)
	self.noCollisionModeId = nil
    self.lightModeId = nil
end

ConstructionScreen.removeBrushActionEvents = Utils.overwrittenFunction(ConstructionScreen.removeBrushActionEvents, ConstructionScreenExtension.removeBrushActionEvents)

function ConstructionScreenExtension.updateBrushActionTexts(self, superFunc)
    superFunc(self)

	if self.noCollisionModeActive then
		g_inputBinding:setActionEventText(self.noCollisionModeId, g_i18n:getText("input_deactivateNoCollisionMode"))
	else
		g_inputBinding:setActionEventText(self.noCollisionModeId, g_i18n:getText("input_activateNoCollisionMode"))
	end

	if self.lightModeActive then
		g_inputBinding:setActionEventText(self.lightModeId, g_i18n:getText("input_deactivateLightMode"))
	else
		g_inputBinding:setActionEventText(self.lightModeId, g_i18n:getText("input_activateLightMode"))
	end
end

ConstructionScreen.updateBrushActionTexts = Utils.overwrittenFunction(ConstructionScreen.updateBrushActionTexts, ConstructionScreenExtension.updateBrushActionTexts)

function ConstructionScreenExtension.onToggleNoCollisionMode()
    g_constructionScreen.noCollisionModeActive = not g_constructionScreen.noCollisionModeActive
    g_constructionScreen.brush.inputTextDirty = true

    if g_constructionScreen.noCollisionModeActive then
        GuiTopDownCamera.COLLISION_MASK = 0
    else
        GuiTopDownCamera.COLLISION_MASK = CollisionMask.ALL - CollisionFlag.TRIGGER - CollisionFlag.GROUND_TIP_BLOCKING - CollisionFlag.TERRAIN_DISPLACEMENT
    end
end

function ConstructionScreenExtension.onToggleLightMode()
    if g_constructionScreen.cu_lightId == nil then
        return
    end

    g_constructionScreen.lightModeActive = not g_constructionScreen.lightModeActive
    g_constructionScreen.brush.inputTextDirty = true

    if g_constructionScreen.lightModeActive then
        setVisibility(g_constructionScreen.cu_lightId, true)
    else
        setVisibility(g_constructionScreen.cu_lightId, false)
    end
end

function ConstructionScreenExtension.updateLightTranslation()
    if
        not g_constructionScreen.lightModeActive or
        g_constructionScreen.cu_lightId == nil or
        g_constructionScreen.cursor == nil or
        g_constructionScreen.cursor.ray == nil or
        g_constructionScreen.cursor.ray.x == nil
    then
        return
    end

    local ray = g_constructionScreen.cursor.ray
	local _, x, y, z = RaycastUtil.raycastClosest(ray.x, ray.y, ray.z, ray.dx, ray.dy, ray.dz, GuiTopDownCursor.RAYCAST_DISTANCE, g_constructionScreen.cursor.rayCollisionMask)
    setTranslation(g_constructionScreen.cu_lightId, x, y, z)
end

ConstructionScreen.update = Utils.appendedFunction(ConstructionScreen.update, ConstructionScreenExtension.updateLightTranslation)

function ConstructionScreenExtension.loadLightIfNeeded()
    if g_constructionScreen.cu_lightId ~= nil then
        return
    end

    local lightPath = Utils.getFilename(ConstructionScreenExtension.lightFileName, ConstructionScreenExtension.modDirectory)
    g_i3DManager:loadI3DFileAsync(lightPath, false, false, ConstructionScreenExtension.lightLoaded, ConstructionScreenExtension, nil)
end

function ConstructionScreenExtension.lightLoaded(args, node, failedReason)
    if node == nil then
        Logging.error("Load light failed with error: "..failedReason)
        return
    end

    g_constructionScreen.cu_lightId = node
    link(getRootNode(), node)
    setVisibility(g_constructionScreen.cu_lightId, false)
end